/*
 *
 * main() routine for the ATmega applications
 *
 * $Id: main.c 65 2008-10-28 19:41:46Z gerry $
 */

#include "defines.h"

#include <avr/io.h>
#include <avr/pgmspace.h>

#include "services.h"
#include "app_timer.h"
#include "lcd.h"
#include "led.h"
#include "key.h"
#include "dcf.h"
#include "kernel_if.h"

/*
 * Do all the startup-time peripheral initializations.
 */
static void do_init(void)
{
    //=================================================
    services_init(); // Always make this call first !
    //=================================================
    timer_init();
    lcd_init();
    led_init();
    key_init();
    dcf_init();
}

void main(void)
{
char rc;
    // do all the initialisations of the HAL
    do_init();

    // now start the SDL system, should run forever
    rc = SDL_main(); // should not normally ever return
    led_on(LED2);    // so we really shouldn't be here
}
