/*
 * HAL API:
 * Key driver
 *
 * Mainly ISRs to tell the application which button
 * (or key) was pressed or released.
 *
 * $Id: key.c 65 2008-10-28 19:41:46Z gerry $
 */

#include "defines.h"
#include <avr/io.h>
#include "key.h"

static msgId_t key_msg[NUM_KEYS];

/*
 * Initialize the keys' input lines
 */
void key_init(void)
{
register unsigned char i;
  // initialize the key input lines
    /* set all bits to 0 */
  KEY_DATA_PORT &= KEY_DATA_INIT;
    /* set bits to input */
  KEY_DATA_DDIR &= KEY_DATA_INP;
  // enable the interrupts on both rising/falling edge
  MCUCR &= ~(_BV(ISC11) | _BV(ISC01));
  MCUCR |=  (_BV(ISC10) | _BV(ISC00));
  GICR  |=  (_BV(INT1) | _BV(INT0));
  // initialize the signal table
  for (i = 0; i < NUM_KEYS; i++)
    key_msg[i] = 0;
}

/*
 * Register for key interrupts
 */
void key_signal(ivect_t v, msgId_t m)
{
  switch(v)
  {
  case IVECT_TASTER_1:
    key_msg[ID_TASTER_1] = m;
    break;
  }
}

/*
 * ISR for all keys connected
 */
SIGNAL(SIG_INTERRUPT0)
{
register char keyState;
  // debounce the key
  keyState = (KEY_DATA_PINS & _BV(KEY_1)) ? KEY_PRESSED : KEY_RELEASED;
  // if a SDL signal is registered, send it.
  if (key_msg[ID_TASTER_1])
    SendMsg(key_msg[ID_TASTER_1], (msgEntry_t)keyState);
}
