#ifndef _KERNEL_IF_H
#define _KERNEL_IF_H
/*
 * JSDL kernel:
 * Header file for the JSDL run-time system (the JSDL kernel)
 * Originally written by Jens Altmann
 *
 * Enhancements by donGerry
 *
 * NOTE: this header must be included by or after 'sysinc.h'
 *       (the generated 'sysinc.h' does include this file).
 *
 * $Id: kernel_if.h 57 2008-10-22 18:43:59Z gerry $
 */

#ifdef _SYSINC
#if (defined(__AVR) && !defined(_8_BIT_CPU))
#error "SDL application for a AVR target must be generated for 8-bit CPU !"
#endif
#endif

#ifndef NULL
#define NULL (void*)0
#endif

#define DBGPORT 2301

#ifdef __AVR
#define MSPERTICK 10
#else
#define MSPERTICK 1
#endif //__AVR

#define MSG_AVAILABLE  0x0001
#define TIMERRUNNING   0x0002
#define TERMSDL        0x0004
#define RESTARTSDL     0x0008
#define RUNSDL         0x0010

#define TRUE   1
#define FALSE  0

#define INITSTATE 0  /*do not change this*/

#define MSGNOTIFY  2
#define MSCENABLE  1

#undef  NOERROR
#define NOERROR                 0
#ifdef __AVR
#define ERR_TIMERNOTFOUND  0xF0
#define ERR_QUEUEOVERFLOW  0xF1
#define ERR_NOTIMERAVAIL   0xF2
#define ERR_UNKNOWNTIMER   0xF3
#define ERR_UNKNOWNMSG     0xF4
#define ERR_INVALIDSTATE   0xF5
#define ERR_EMPTYDESCISION 0xF6
#else
#define ERR_TIMERNOTFOUND  0xF000
#define ERR_QUEUEOVERFLOW  0xF100
#define ERR_NOTIMERAVAIL   0xF200
#define ERR_UNKNOWNTIMER   0xF300
#define ERR_UNKNOWNMSG     0xF400
#define ERR_INVALIDSTATE   0xF500
#define ERR_EMPTYDESCISION 0xF600
#endif //__AVR

#define MaxNoOfQueueEntries 10
#define MaxNoOfTimerEntries 10
#define MaxNoOfProcesses NoOfProcesses+4

#ifdef __AVR
typedef unsigned char  pID_t;
typedef unsigned short msgId_t;
typedef unsigned short msgEntry_t;
typedef unsigned short timerval_t;
typedef char           retPar_t;
typedef unsigned char  ivect_t;
#else
typedef unsigned short pID_t;
typedef unsigned long  msgId_t;
typedef unsigned long  msgEntry_t;
typedef unsigned long  timerval_t;
typedef int  retPar_t;
#endif //__AVR

#define PROCESSENTRY(thisproc)
#define PROCESSEXIT(thisproc)

#define PROCESS_FCTPARM procVal_t* thisProc
#define msgpar (thisProc->pMsg->msg)
#define curState (thisProc->state)
#define SIGID (thisProc->pMsg->msgID)

typedef struct
{
  msgId_t        msgID;
  msgEntry_t     msg;
  pID_t          senderPid;
  pID_t          receiverPid;
} msg_t;

typedef struct
{
#ifdef __AVR
  void*         pPrivatData;
  unsigned char procid;
  unsigned char instanceCnt;
  unsigned char state;
  msg_t*        pMsg;
#else
  void*        pPrivatData;
  unsigned int procid;
  unsigned int instanceCnt;
  unsigned int state;
  msg_t*       pMsg;
  const char * processname;
#endif //__AVR
} procVal_t;

typedef struct
{
  procVal_t  thisProcess;
  retPar_t (*proc)(PROCESS_FCTPARM);
} procTabEntry_t;

typedef retPar_t (*sdlproc_t)(PROCESS_FCTPARM);
typedef void (*sdlInitproc_t)();
typedef void (*sdlExitproc_t)();

typedef struct
{
  sdlproc_t      processEntry;
  sdlInitproc_t  processInit;
  sdlExitproc_t  processExit;
  const char*    processName;
} processDef_t;


typedef struct TIMERENTRY
{
  timerval_t    t;
  struct TIMERENTRY* pNext;
  msgId_t       msgId;
  pID_t         sendByPid;
} timerEntry_t;

#ifdef __AVR
extern char SetSdlTimer( char timerid,unsigned short elapseticks);
extern char KillSdlTimer(char timerid);
extern char ReQueueMessage(msg_t* pMsg);
extern char SendMsg(msgId_t msgID, msgEntry_t msgPar);
extern char SDL_main(void);
#define RunTimeError(x)

void GetCurTime( timerval_t* pCurTime);
void GetTimeDiff(timerval_t* pt2,timerval_t* pt1,timerval_t* ptdiff);
void AddTimeVals(timerval_t* pt2,timerval_t* pt1);
#else
extern int SetSdlTimer( int timerid,unsigned long elapseticks);
extern int KillSdlTimer(int timerid);
extern int ReQueueMessage(msg_t* pMsg);
extern int SendMsg(msgId_t msgID, msgEntry_t msgPar);
extern void (*dbg[])(unsigned long symbolID);
extern int InitDbgSocket();
extern void ResetDbgStepMode();
extern void SendString(char* txt);
extern void SendFrame(unsigned char* pFrame);
extern void CloseSocket();
extern int Debug();
extern void InitDebugTable( void(*fct)(unsigned long) );
extern void RunTimeError( unsigned long errorcode );
extern void TRACE(char* TraceText);

void GetCurTime( timerval_t* pCurTime);
void GetTimeDiff(timerval_t* pt2,timerval_t* pt1,timerval_t* ptdiff);
void AddTimeVals(timerval_t* pt2,timerval_t* pt1);
#endif //__AVR

#endif /* _KERNEL_IF_H */
